import React from 'react';
import { LogoIcon, SearchIcon } from './Icons';

const Header: React.FC = () => {
  return (
    <header className="sticky top-0 z-10 bg-[#1a1b24] p-4 border-b border-white/10">
      <div className="flex justify-between items-center">
        <div className="flex items-center gap-2">
          <LogoIcon />
          <h1 className="text-white font-bold text-2xl tracking-tighter">SLAVA</h1>
        </div>
        <SearchIcon className="h-6 w-6 text-gray-400" />
      </div>
    </header>
  );
};

export default Header;