import React from 'react';
import FeaturedSection from './FeaturedSection';
import TrendingSection from './TrendingSection';
import { Song } from '../types';

interface HomePageProps {
  songs: Song[];
  playingSongId: number | null;
  onPlaySong: (song: Song) => void;
}

const HomePage: React.FC<HomePageProps> = ({ songs, playingSongId, onPlaySong }) => {
  return (
    <>
      <FeaturedSection />
      <TrendingSection songs={songs} playingSongId={playingSongId} onPlaySong={onPlaySong} />
    </>
  );
};

export default HomePage;
