import React from 'react';
import { Song } from '../types';
import { PlayIcon, PauseIcon, HeartIcon } from './Icons';

interface MiniPlayerProps {
  song: Song;
  isPlaying: boolean;
  onTogglePlay: () => void;
  onOpenModal: () => void;
}

const MiniPlayer: React.FC<MiniPlayerProps> = ({ song, isPlaying, onTogglePlay, onOpenModal }) => {
  return (
    <div className="fixed bottom-[65px] left-0 right-0 bg-[#2a2b37]/90 backdrop-blur-md z-20 animate-fade-in">
        <div className="flex items-center p-2" onClick={onOpenModal} role="button" tabIndex={0}>
            <img src={song.imageUrl} alt={song.title} className="w-12 h-12 rounded-md object-cover" />
            <div className="flex-1 mx-3 min-w-0">
                <p className="text-white font-semibold truncate">{song.title}</p>
                <p className="text-gray-400 text-sm truncate">{song.artist}</p>
            </div>
            <div className="flex items-center space-x-3 pr-2">
                <button className="text-gray-300 hover:text-white transition-colors" onClick={(e) => { e.stopPropagation(); /* logic to like */ }}>
                    <HeartIcon className="w-6 h-6" />
                </button>
                <button onClick={(e) => { e.stopPropagation(); onTogglePlay(); }} className="text-white" aria-label={isPlaying ? "Pause" : "Play"}>
                    {isPlaying ? <PauseIcon className="w-8 h-8"/> : <PlayIcon className="w-8 h-8"/>}
                </button>
            </div>
        </div>
        {/* Progress bar could go here */}
        <div className="h-0.5 bg-gray-700">
            <div className="h-0.5 bg-purple-500" style={{width: '30%'}}></div>
        </div>
    </div>
  );
};

export default MiniPlayer;
