import React from 'react';
import { ArrowLeftIcon, GoogleIcon, DiscordIcon } from './Icons';

const MorePage: React.FC = () => {
    return (
        <div className="min-h-screen bg-[#21222d] text-white flex flex-col p-4 animate-fade-in">
            <header className="flex-shrink-0">
                <button className="p-2 -ml-2">
                    <ArrowLeftIcon className="h-6 w-6" />
                </button>
            </header>
            
            <main className="flex-grow flex flex-col justify-center pb-20">
                <div className="w-full max-w-sm mx-auto text-center">
                    <h1 className="text-3xl font-bold mb-8">Вход или регистрация</h1>

                    <div className="space-y-4">
                        <button className="w-full bg-[#30313d] hover:bg-[#3c3d4a] text-white font-semibold py-3 px-4 rounded-xl flex items-center justify-center transition-colors">
                            <GoogleIcon className="w-5 h-5 mr-3" />
                            Продолжить с Google
                        </button>
                        <button className="w-full bg-[#30313d] hover:bg-[#3c3d4a] text-white font-semibold py-3 px-4 rounded-xl flex items-center justify-center transition-colors">
                            <DiscordIcon className="w-5 h-5 mr-3" />
                            Продолжить с Discord
                        </button>
                    </div>

                    <div className="flex items-center my-6">
                        <hr className="flex-grow border-gray-600"/>
                        <span className="mx-4 text-gray-400 text-sm">или</span>
                        <hr className="flex-grow border-gray-600"/>
                    </div>

                    <div className="flex space-x-2">
                        <div className="flex-shrink-0 bg-[#30313d] rounded-xl flex items-center px-4">
                            <span role="img" aria-label="USA flag">🇺🇸</span>
                            <span className="ml-2 font-semibold">+1</span>
                        </div>
                        <input
                            type="tel"
                            placeholder="Введите номер телефона..."
                            className="w-full bg-[#30313d] text-white rounded-xl py-3 px-4 placeholder-gray-500 focus:ring-2 focus:ring-purple-500 focus:outline-none transition"
                        />
                    </div>
                    
                    <button className="w-full bg-[#4f46e5] hover:bg-[#4338ca] text-white font-bold py-3 px-4 rounded-xl mt-6 transition-colors">
                        Продолжить
                    </button>

                    <p className="text-xs text-gray-500 mt-6">
                        Продолжая, вы соглашаетесь с нашими <a href="#" className="underline hover:text-white">Условиями обслуживания</a> и <a href="#" className="underline hover:text-white">Политикой конфиденциальности</a>.
                    </p>
                </div>
            </main>
        </div>
    );
};

export default MorePage;