<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Third Party Services
    |--------------------------------------------------------------------------
    |
    | This file is for storing the credentials for third party services such
    | as Mailgun, Postmark, AWS and more. This file provides the de facto
    | location for this type of information, allowing packages to have
    | a conventional file to locate the various service credentials.
    |
    */

    'postmark' => [
        'key' => env('POSTMARK_API_KEY'),
    ],

    'resend' => [
        'key' => env('RESEND_API_KEY'),
    ],

    'ses' => [
        'key' => env('AWS_ACCESS_KEY_ID'),
        'secret' => env('AWS_SECRET_ACCESS_KEY'),
        'region' => env('AWS_DEFAULT_REGION', 'us-east-1'),
    ],

    'slack' => [
        'notifications' => [
            'bot_user_oauth_token' => env('SLACK_BOT_USER_OAUTH_TOKEN'),
            'channel' => env('SLACK_BOT_USER_DEFAULT_CHANNEL'),
        ],
    ],

    'telegram' => [
        'bot_token' => env('TELEGRAM_BOT_TOKEN'),
        'webapp_url' => env('TELEGRAM_WEBAPP_URL'),
        'login_bot' => env('TELEGRAM_LOGIN_BOT'),
    ],

    'vkid' => [
        'app_id' => (int) env('VKID_APP_ID', 0),
        'access_key' => env('VKID_ACCESS_KEY'),
        'redirect_url' => env('VKID_REDIRECT_URL', env('APP_URL', 'https://sunoai.ru')),
        'domain' => env('VKID_DOMAIN', 'id.vk.com'),
    ],

    'demo_auth' => [
        'enabled' => env('AUTH_DEMO_ENABLED', true),
        'name' => env('AUTH_DEMO_NAME', 'Demo User'),
        'email' => env('AUTH_DEMO_EMAIL', 'demo@sunoai.ru'),
    ],

    'suno' => [
        'base_url' => env('SUNO_API_BASE_URL', 'https://api.sunoapi.org'),
        'api_key' => env('SUNO_API_KEY'),
        'callback_url' => env('SUNO_CALLBACK_URL'),
        'token_cost' => (int) env('SUNO_TOKEN_COST', 0),
    ],

];
