<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            if (!Schema::hasColumn('users', 'token_balance')) {
                $table->unsignedInteger('token_balance')->default(0)->after('telegram_init_data');
            }

            if (!Schema::hasColumn('users', 'generation_count')) {
                $table->unsignedInteger('generation_count')->default(0)->after('token_balance');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            if (Schema::hasColumn('users', 'generation_count')) {
                $table->dropColumn('generation_count');
            }

            if (Schema::hasColumn('users', 'token_balance')) {
                $table->dropColumn('token_balance');
            }
        });
    }
};










