<!DOCTYPE html>
<html lang="ru">
    <head>
        <meta charset="utf-8">
        <title>Telegram Авторизация</title>
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <style>
            body {
                margin: 0;
                padding: 2rem;
                font-family: system-ui, -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
                background: #111827;
                color: #e5e7eb;
                display: flex;
                align-items: center;
                justify-content: center;
                min-height: 100vh;
                text-align: center;
            }
            .card {
                background: rgba(17, 24, 39, 0.9);
                border: 1px solid rgba(148, 163, 184, 0.2);
                border-radius: 1rem;
                padding: 2rem;
                max-width: 24rem;
                width: 100%;
                box-shadow: 0 20px 60px rgba(76, 29, 149, 0.35);
            }
            h1 {
                font-size: 1.5rem;
                margin-bottom: 0.75rem;
            }
            p {
                margin: 0;
                color: #94a3b8;
            }
        </style>
    </head>
    <body>
        <div class="card">
            <h1>Возвращаемся в Melodist…</h1>
            <p>Это окно закроется автоматически</p>
        </div>
        <script>
            (function () {
                function parseFragment() {
                    var hash = window.location.hash || '';
                    if (hash.startsWith('#')) {
                        hash = hash.slice(1);
                    }
                    return new URLSearchParams(hash);
                }

                function decodeResult(value) {
                    if (!value) {
                        return null;
                    }
                    try {
                        return JSON.parse(decodeURIComponent(value));
                    } catch (error) {
                        return null;
                    }
                }

                var params = parseFragment();
                var resultRaw = params.get('tgAuthResult');
                var errorRaw = params.get('tgAuthError');
                var payload = decodeResult(resultRaw);
                var errorMessage = errorRaw ? decodeURIComponent(errorRaw) : null;

                if (window.opener && !window.opener.closed) {
                    window.opener.postMessage(
                        {
                            source: 'telegram-auth-callback',
                            payload: payload,
                            error: errorMessage,
                        },
                        window.location.origin
                    );
                }

                setTimeout(function () {
                    try {
                        window.close();
                    } catch (closeError) {
                        // ignore close errors
                    }
                }, 150);
            })();
        </script>
    </body>
</html>

