import type { SVGProps } from 'react';
import type { LucideProps } from 'lucide-react';
import {
  ArrowLeft,
  AudioLines,
  BadgeCheck,
  ChevronDown,
  ChevronLeft,
  ChevronRight,
  Coins,
  Flame,
  Folder,
  Grid3x3,
  Heart,
  Home,
  Library,
  ListMusic,
  Loader2,
  MoreHorizontal,
  Pause,
  Play,
  PlusCircle,
  Repeat,
  Search,
  Shuffle,
  SkipBack,
  SkipForward,
  Sparkles,
  UserRound,
} from 'lucide-react';

type IconProps = LucideProps;

// From Header
export const LogoIcon = (props: SVGProps<SVGSVGElement>) => (
    <svg
        xmlns="http://www.w3.org/2000/svg"
        viewBox="0 0 24 24"
        fill="currentColor"
        className="w-8 h-8 text-purple-500"
        {...props}
    >
        <path
            fillRule="evenodd"
            d="M12 2.25c-5.385 0-9.75 4.365-9.75 9.75s4.365 9.75 9.75 9.75 9.75-4.365 9.75-9.75S17.385 2.25 12 2.25zM12 8.25a.75.75 0 01.75.75v3.75a.75.75 0 01-1.5 0V9a.75.75 0 01.75-.75zm0 8.25a.75.75 0 100-1.5.75.75 0 000 1.5z"
            clipRule="evenodd"
        />
    </svg>
);
export const SearchIcon = (props: IconProps) => <Search {...props} />;

// From SongItem
export const VerifiedIcon = (props: IconProps) => <BadgeCheck {...props} />;
export const MoreHorizontalIcon = (props: IconProps) => <MoreHorizontal {...props} />;
export const SoundWaveIcon = (props: IconProps) => <AudioLines {...props} />;

// From BottomNav
export const HomeIcon = (props: IconProps) => <Home {...props} />;
export const PlusCircleIcon = (props: IconProps) => <PlusCircle {...props} />;
export const LibraryIcon = (props: IconProps) => <Library {...props} />;
export const UserIcon = (props: IconProps) => <UserRound {...props} />;
export const GenerationsIcon = (props: IconProps) => <Sparkles {...props} />;
export const BalanceIcon = (props: IconProps) => <Coins {...props} />;

// From CreatePage
export const PlayIcon = (props: IconProps) => <Play {...props} />;
export const PauseIcon = (props: IconProps) => <Pause {...props} />;
export const SpinnerIcon = (props: IconProps) => <Loader2 {...props} />;

// From MorePage
export const ArrowLeftIcon = (props: IconProps) => <ArrowLeft {...props} />;
export const GoogleIcon = (props: SVGProps<SVGSVGElement>) => (
    <svg viewBox="0 0 48 48" {...props}>
        <path fill="#FFC107" d="M43.611 20.083H42V20H24v8h11.303c-1.649 4.657-6.08 8-11.303 8c-6.627 0-12-5.373-12-12s5.373-12 12-12c3.059 0 5.842 1.154 7.961 3.039l5.657-5.657C34.046 6.053 29.268 4 24 4C12.955 4 4 12.955 4 24s8.955 20 20 20s20-8.955 20-20c0-1.341-.138-2.65-.389-3.917z"></path>
        <path fill="#FF3D00" d="M6.306 14.691l6.571 4.819C14.655 15.108 18.961 12 24 12c3.059 0 5.842 1.154 7.961 3.039l5.657-5.657C34.046 6.053 29.268 4 24 4C16.318 4 9.656 8.337 6.306 14.691z"></path>
        <path fill="#4CAF50" d="M24 44c5.166 0 9.86-1.977 13.409-5.192l-6.19-5.238C29.211 35.091 26.715 36 24 36c-5.222 0-9.618-3.226-11.283-7.581l-6.522 5.025C9.505 39.556 16.227 44 24 44z"></path>
        <path fill="#1976D2" d="M43.611 20.083H42V20H24v8h11.303c-.792 2.237-2.231 4.166-4.087 5.571l6.19 5.238C42.012 35.197 44 30.023 44 24c0-1.341-.138-2.65-.389-3.917z"></path>
    </svg>
);
export const DiscordIcon = (props: SVGProps<SVGSVGElement>) => (
    <svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" fill="currentColor" {...props}>
        <title>Discord</title>
        <path d="M20.317 4.3698a19.7913 19.7913 0 00-4.8852-1.5152.0741.0741 0 00-.0785.0371c-.211.3753-.4464.8254-.6182 1.2526a17.2969 17.2969 0 00-5.4856 0c-.1718-.4271-.4072-.8772-.6182-1.2526a.0741.0741 0 00-.0785-.0371a19.7913 19.7913 0 00-4.8852 1.5152.069.069 0 00-.0321.0277C.5334 9.0458-.319 13.5799.0992 18.0578a.0823.0823 0 00.0321.0546c1.6923 1.0377 3.553 1.6348 5.461 1.9556a.078.078 0 00.087-.063c.1622-.5765.293-1.1633.3897-1.7554a.07.07 0 00-.048-.0798a12.1802 12.1802 0 01-1.571-.6217.0741.0741 0 01-.021-.1177c.1054-.131.2108-.262.3075-.4018a.0741.0741 0 01.096-.021c3.5413 1.6348 7.3734 1.6348 10.9147 0a.0741.0741 0 01.096.021c.0967.1398.2021.2708.3075.4018a.0741.0741 0 01-.021.1177a12.1802 12.1802 0 01-1.571.6217.07.07 0 00-.048.0798c.0967.5921.2275 1.1789.3897 1.7554a.078.078 0 00.087.063c1.908-.3208 3.7687-.918 5.461-1.9556a.0823.0823 0 00.0321-.0546c.527-4.5878-.2938-9.1118-2.656-13.6602a.069.069 0 00-.0321-.0277zM8.02 15.3312c-.9432 0-1.71-.7736-1.71-1.7283s.7668-1.7283 1.71-1.7283c.9432 0 1.71.7736 1.71 1.7283s-.7668 1.7283-1.71 1.7283zm7.9748 0c-.9432 0-1.71-.7736-1.71-1.7283s.7668-1.7283 1.71-1.7283c.9432 0 1.71.7736 1.71 1.7283s-.7668 1.7283-1.71 1.7283z"/>
    </svg>
);

// From Player
export const HeartIcon = (props: IconProps) => <Heart {...props} />;
export const ChevronDownIcon = (props: IconProps) => <ChevronDown {...props} />;
export const SkipBackIcon = (props: IconProps) => <SkipBack {...props} />;
export const SkipForwardIcon = (props: IconProps) => <SkipForward {...props} />;
export const ShuffleIcon = (props: IconProps) => <Shuffle {...props} />;
export const RepeatIcon = (props: IconProps) => <Repeat {...props} />;

// Desktop components
export { ChevronLeft, ChevronRight, Grid3x3, Flame, Folder, ListMusic };
