import React from 'react';
import SongItem from './SongItem';
import { Song } from '../types';

interface TrendingSectionProps {
  songs: Song[];
  playingSongId: string | null;
  onPlaySong: (song: Song) => void;
}

const TrendingSection: React.FC<TrendingSectionProps> = ({ songs, playingSongId, onPlaySong }) => {
  
  const handleTogglePlay = (songId: string) => {
    const songToPlay = songs.find(s => s.id === songId);
    if (songToPlay) {
      onPlaySong(songToPlay);
    }
  };

  if (songs.length === 0) {
    return (
      <section className="px-4 py-2 mt-4">
        <h2 className="text-white font-bold text-2xl mb-2">В тренде</h2>
        <p className="text-sm text-gray-400">
          Здесь появятся ваши сгенерированные треки после завершения генерации.
        </p>
      </section>
    );
  }

  return (
    <section className="px-4 py-2 mt-4">
      <h2 className="text-white font-bold text-2xl mb-4">В тренде</h2>
      <div className="flex flex-col space-y-2">
        {songs.map((song, index) => (
          <SongItem 
            key={song.id} 
            song={song}
            rank={String(index + 1).padStart(2, '0')}
            isPlaying={playingSongId === song.id}
            onTogglePlay={handleTogglePlay} 
          />
        ))}
      </div>
    </section>
  );
};

export default TrendingSection;
