
export interface Song {
  id: string;
  taskId: string;
  title: string;
  artist?: string | null;
  prompt?: string | null;
  tags?: string | null;
  artworkUrl?: string | null;
  sourceArtworkUrl?: string | null;
  audioUrl?: string | null;
  sourceAudioUrl?: string | null;
  streamUrl?: string | null;
  sourceStreamUrl?: string | null;
  sourceAudioId?: string | null;
  status: string;
  model?: string | null;
  durationSeconds?: number | null;
  createdAt: string;
  isPlaceholder?: boolean;
  isPublic?: boolean;
  publishedAt?: string | null;
  playsCount?: number;
  likesCount?: number;
}

export interface GenerationTask {
  id: string;
  status: string;
  callbackType?: string | null;
  code?: number | null;
  message?: string | null;
  songs: Song[];
  createdAt: string;
  updatedAt: string;
  meta?: Record<string, unknown> | null;
}

export interface AuthUser {
  id: number;
  name: string | null;
  email: string | null;
  is_telegram: boolean;
  telegram_id: number | null;
  telegram_username: string | null;
  telegram_first_name: string | null;
  telegram_last_name: string | null;
  telegram_photo_url: string | null;
  telegram_init_data?: Record<string, unknown> | null;
  vkid_user_id?: string | null;
  last_login_at: string | null;
  created_at: string;
  updated_at: string;
  generation_count?: number | null;
  token_balance?: number | null;
}
